<?php
class ControllerExtensionPaymentFlowWebpay extends Controller {
	private $error = array();

	public function index() {
        $this->load->language('extension/payment/flow_webpay');
        $this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');
		$privData = $this->getData();
		/* REQUEST */
		if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
			$this->model_setting_setting->editSetting('flow_webpay', $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true));
		}
		/* FIN REQUEST */
        $this->setTranslations($privData);
        $this->setErrorInfo($privData);
        $this->setBreadcrumbs($privData);
        $this->updateEditors($privData);

		if (isset($this->session->data['success'])) {
			$privData['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$privData['success'] = '';
		}

		/* MOSTRAR DATOS */
		$this->load->model('localisation/order_status');
		$privData['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		$this->load->model('localisation/geo_zone');
		$privData['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		/* FIN MOSTRAR DATOS */

		$privData['action'] = $this->url->link('extension/payment/flow_webpay', 'token=' . $this->session->data['token'], true);
		$privData['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=payment', true);
		$privData['header'] = $this->load->controller('common/header');
		$privData['column_left'] = $this->load->controller('common/column_left');
		$privData['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view('extension/payment/flow_webpay.tpl', $privData));
	}

    private function updateEditors(&$privData) {
        $this->updateEditor($privData, 'flow_webpay_apikey');
        $this->updateEditor($privData, 'flow_webpay_secret');
        $this->updateEditor($privData, 'flow_webpay_apiurl');
        $this->updateEditor($privData, 'flow_webpay_status');
        $this->updateEditor($privData, 'flow_webpay_payment_name');
        $this->updateEditor($privData, 'flow_webpay_sort_order');
        $this->updateEditor($privData, 'flow_webpay_geo_zone_id');
        $this->updateEditor($privData, 'flow_webpay_approved_status_id');
        $this->updateEditor($privData, 'flow_webpay_failed_status_id');
        $this->updateEditor($privData, 'flow_webpay_urlreturn');

    }

    private function setTranslations(&$privData) {
        $privData['heading_title'] = $this->language->get('heading_title');
        $privData['text_edit'] = $this->language->get('text_edit');
        $privData['text_payment'] = $this->language->get('text_payment');
        $privData['text_success'] = $this->language->get('text_success');
        $privData['text_flow_webpay'] = $this->language->get('text_flow_webpay');
        $privData['flow_test_site'] = $this->language->get('flow_test_site');
        $privData['flow_site'] = $this->language->get('flow_site');
        $privData['text_all_zones'] = $this->language->get('text_all_zones');
        $privData['text_enabled'] = $this->language->get('text_enabled');
        $privData['text_disabled'] = $this->language->get('text_disabled');
        $privData['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $privData['entry_status'] = $this->language->get('entry_status');
        $privData['entry_sort_order'] = $this->language->get('entry_sort_order');
        $privData['entry_payment_name'] = $this->language->get('entry_payment_name');
        $privData['entry_secret'] = $this->language->get('entry_secret');
        $privData['entry_approved_status'] = $this->language->get('entry_approved_status');
        $privData['entry_failed_status'] = $this->language->get('entry_failed_status');
        $privData['entry_apikey'] = $this->language->get('entry_apikey');
        $privData['entry_apiurl'] = $this->language->get('entry_apiurl');
        $privData['entry_urlreturn'] = $this->language->get('entry_urlreturn');
        $privData['placeholder_receiverid'] = $this->language->get('placeholder_receiverid');
        $privData['placeholder_title'] = $this->language->get('placeholder_title');
        $privData['tip_status_complete'] = $this->language->get('tip_status_complete');
        $privData['tip_status_failed']   = $this->language->get('tip_status_failed');
        $privData['entry_platform'] = $this->language->get('entry_platform');
        $privData['flow_test_site'] = $this->language->get('flow_test_site');
        $privData['flow_site'] = $this->language->get('flow_site');
        $privData['button_save'] = $this->language->get('button_save');
        $privData['button_cancel'] = $this->language->get('button_cancel');
        $privData['has_private_key'] = $this->language->get('has_private_key');
    }

    private function setErrorInfo(&$privData) {
        $this->handleError($privData, 'warning');
        $this->handleError($privData, 'receiverid');
        $this->handleError($privData, 'title');
        $this->handleError($privData, 'privatekey');
        $this->handleError($privData, 'type');
        $this->handleError($privData, 'apikey');
        $this->handleError($privData, 'secret');
        $this->handleError($privData, 'apiurl');
        $this->handleError($privData, 'payment_name');
    }

    private function setBreadcrumbs(&$privData) {
        $privData['breadcrumbs'] = array();
        $this->addBreadCrumb($privData, 'text_home', 'common/home', false);
        $this->addBreadCrumb($privData, 'text_payment', 'extension/payment', ' :: ');
        $this->addBreadCrumb($privData, 'heading_title', 'extension/payment/flow_webpay', ' :: ');
    }

	private function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/flow_webpay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if(!$this->request->post['flow_webpay_apikey']){
			$this->error['apikey'] = $this->language->get('error_apikey');
		}

		if(!$this->request->post['flow_webpay_secret']){
			$this->error['secret'] = $this->language->get('error_secret');
		}

		if(!$this->request->post['flow_webpay_apiurl']){
			$this->error['apiurl'] = $this->language->get('error_apiurl');
		}

        if(!$this->request->post['flow_webpay_payment_name']){
            $this->error['payment_name'] = $this->language->get('error_payment_name');
        }
		return !$this->error;
	}
	// Utility functions

    private function handleError(&$privData, $type) {
        if (isset($this->error[$type])) {
            $privData['error_'.$type] = $this->error[$type];
        } else {
            $privData['error_'.$type] = '';
        }
    }

    private function addBreadCrumb(&$privData, $title, $link, $separator) {
        $privData['breadcrumbs'][] = array(
                'text'      => $this->language->get($title),
                'href'      => $this->url->link($link, 'token=' . $this->session->data['token'], 'SSL'),
                'separator' => $separator
        );
    }

    private function updateEditor(&$privData, $editor) {
        if (isset($this->request->post[$editor])) {
            $privData[$editor] = $this->request->post[$editor];
        } else {
            $privData[$editor] = $this->config->get($editor);
        }
    }
    
	private function getData() {
		if ($this->isVersion1()) {
			return $this->data;
		}
		return array();
	}
	
	private function isVersion1() {
		return version_compare(VERSION, '2.0.0.0', '<');
	}
}
