<?php echo $header; ?><?php echo $column_left; ?>
    <div id="content">
        <div class="page-header">
            <div class="container-fluid">
                <div class="pull-right">
                    <button type="submit" form="form-payment" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
                    <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a>
                </div>
                <h1><?php echo $heading_title; ?></h1>
                <ul class="breadcrumb">
                    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                        <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                    <?php } ?>
                </ul>
            </div>
        </div>

        <div class="container-fluid">
            <?php if ($error_warning) { ?>
                <div class="alert alert-danger alert-dismissible"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
            <?php } ?>
        </div>

        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
            </div>
        </div>

        <div class="panel-body">
            <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-payment" class="form-horizontal">

                 <div class="form-group">
                    <label class="col-sm-2 control-label" for="flow_webpay_apiurl"><?php echo $entry_apiurl; ?></label>
                    <div class="col-sm-10">
                        <select name="flow_webpay_apiurl" id="flow_webpay_apiurl" class="form-control">
                            <?php if ($flow_webpay_apiurl == 'TEST') { ?>
                                <option value="TEST" selected="selected"><?php echo $flow_test_site; ?></option>
                                <option value="PROD"><?php echo $flow_site; ?></option>
                            <?php } else { ?>
                                <option value="TEST"><?php echo $flow_test_site; ?></option>
                                <option value="PROD" selected="selected"><?php echo $flow_site; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="tab-content">
                    <div class="form-group required">
                        <label class="col-sm-2 control-label" for="entry_payment_name"><?php echo $entry_payment_name; ?></label>
                        <div class="col-sm-10">
                            <input type="text" name="flow_webpay_payment_name" value="<?php echo $flow_webpay_payment_name; ?>" placeholder="<?php echo $entry_payment_name; ?>" id="entry_payment_name" class="form-control"/>
                            <?php if ($error_payment_name) { ?>
                                <div class="text-danger"><?php echo $error_payment_name; ?></div>
                            <?php } ?>
                        </div>
                    </div>
                </div>

                <div class="tab-content">
                    <div class="form-group required">
                        <label class="col-sm-2 control-label" for="entry-apikey"><?php echo $entry_apikey; ?></label>
                        <div class="col-sm-10">
                            <input type="text" name="flow_webpay_apikey" value="<?php echo $flow_webpay_apikey; ?>" placeholder="<?php echo $entry_apikey; ?>" id="entry-apikey" class="form-control"/>
                            <?php if ($error_apikey) { ?>
                                <div class="text-danger"><?php echo $error_apikey; ?></div>
                            <?php } ?>
                        </div>
                    </div>
                </div>

                <div class="tab-content">
                    <div class="form-group required">
                        <label class="col-sm-2 control-label" for="entry-secret"><?php echo $entry_secret; ?></label>
                        <div class="col-sm-10">
                            <input type="text" name="flow_webpay_secret" value="<?php echo $flow_webpay_secret; ?>" placeholder="<?php echo $entry_secret; ?>" id="entry-secret" class="form-control"/>
                            <?php if ($error_secret) { ?>
                                <div class="text-danger"><?php echo $error_secret; ?></div>
                            <?php } ?>
                        </div>
                    </div>
                </div>

               

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="input-order-status"><?php echo $entry_approved_status; ?></label>
                    <div class="col-sm-10">
                        <select name="flow_webpay_approved_status_id" id="input-order-status" class="form-control">
                            <?php foreach ($order_statuses as $order_status) { ?>
                                <?php if ($order_status['order_status_id'] == $flow_webpay_approved_status_id) { ?>
                                    <option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
                                <?php } else { ?>
                                    <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                <?php } ?>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="input-order-status"><?php echo $entry_failed_status; ?></label>
                    <div class="col-sm-10">
                        <select name="flow_webpay_failed_status_id" id="input-order-status" class="form-control">
                            <?php foreach ($order_statuses as $order_status) { ?>
                                <?php if ($order_status['order_status_id'] == $flow_webpay_failed_status_id) { ?>
                                    <option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
                                <?php } else { ?>
                                    <option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
                                <?php } ?>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                  <label class="col-sm-2 control-label" for="input-geo-zone"><?php echo $entry_geo_zone; ?></label>
                  <div class="col-sm-10">
                    <select name="flow_webpay_geo_zone_id" id="input-geo-zone" class="form-control">
                      <option value="0"><?php echo $text_all_zones; ?></option>
                      <?php foreach ($geo_zones as $geo_zone) { ?>
                          <?php if ($geo_zone['geo_zone_id'] == $flow_webpay_geo_zone_id) { ?>
                            <option value="<?php echo $geo_zone['geo_zone_id']; ?>" selected="selected"><?php echo $geo_zone['name']; ?></option>
                          <?php } else { ?>
                            <option value="<?php echo $geo_zone['geo_zone_id']; ?>"><?php echo $geo_zone['name']; ?></option>
                          <?php } ?>
                      <?php } ?>
                    </select>
                  </div>
                </div>
                
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="flow_webpay_status"><?php echo $entry_status; ?></label>
                    <div class="col-sm-10">
                        <select name="flow_webpay_status" id="flow_webpay_status" class="form-control">
                            <?php if ($flow_webpay_status) { ?>
                                <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                                <option value="0"><?php echo $text_disabled; ?></option>
                            <?php } else { ?>
                                <option value="1"><?php echo $text_enabled; ?></option>
                                <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                  <label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
                  <div class="col-sm-10">
                    <input type="text" name="flow_webpay_sort_order" value="<?php echo $flow_webpay_sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
                  </div>
                </div>
                		
            </form>
        </div>
    </div>
<?php echo $footer; ?>
