<?php

class ControllerExtensionPaymentCoupon extends Controller {

    public function index(){

		$this->load->language('extension/payment/coupon');
		$this->load->language('extension/payment/flow_webpay');
        $this->document->setTitle($this->language->get('heading_title'));

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
        
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('coupon_message_breadcrumb'),
			'href' => $this->url->link('extension/payment/coupon')
		);

		$data['text_message'] = $this->language->get('coupon_message');
		$data['heading_title'] = $this->language->get('coupon_title');
		$data['continue'] = $this->url->link('common/home');
		$data['button_continue'] = $this->language->get('continue');

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

        $this->response->setOutput($this->load->view('extension/payment/coupon', $data));
        
    }
}