<?php

class ControllerExtensionPaymentFlowWebpay extends Controller {

	var $medio_pago="webpay";

	private function getPaymentMethod(){
		if($this->medio_pago=="webpay"){
			return 1;
		}else if($this->medio_pago=="servipag"){
			return 2;
		}else if($this->medio_pago=="multicaja"){
			return 3;
		}else if($this->medio_pago == 'onepay'){
			return 5;
		}else if($this->medio_pago == 'cryptocompra'){
			return 8;
		}else if($this->medio_pago=="flow"){
			return 9;
		}else{
			return 1;
		}

	}	

	public function index() {
		$this->load->language('extension/payment/flow_webpay');
		$data['action'] = '?route=extension/payment/flow_webpay/paymentCreate';
		$data['button_confirm'] = $this->language->get('button_confirm');
		return $this->load->view('extension/payment/flow_webpay', $data);
	}

	public function customError(){

		$this->load->language('extension/payment/flow_webpay');
		$this->load->language('checkout/success');

        $this->document->setTitle($this->language->get('flow_page_title'));

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);
		
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_checkout'),
			'href' => $this->url->link('checkout/checkout', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('flow_custom_error_breadcrumb'),
			'href' => $this->url->link('extension/payment/flow_webpay/customError')
		);

		$data['text_message'] = $this->language->get('flow_generic_error_message');
		$data['heading_title'] = 'Error';
		$data['button_continue'] = $this->language->get('continue');
		$data['continue'] = $this->url->link('common/home');

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

        $this->response->setOutput($this->load->view('extension/payment/flow_webpay_custom_error', $data));
	}

	/**
	 * Creates a new payment in Flow and redirects the user in order to pay.
	 *
	 * @return mixed
	 */
	public function paymentCreate(){

		$this->log('Entering paymentCreate...');
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$serviceName = "payment/create";
		$subject = 'Orden # '.$order_info['order_id'].' - '.$this->config->get('config_name');
		$amount = (int)$order_info['total'];
		$userEmail = $order_info['email'];
		$commerceOrder = $this->session->data['order_id'];
		$urlConfirmation = $this->url->link('extension/payment/flow_webpay/confirm');
		$urlReturn = $this->url->link('extension/payment/flow_webpay/gatewayRedirect');

		$params = array(
	        "commerceOrder" => $commerceOrder, 
	        "subject" => $subject, 
	        "currency" => "CLP", 
	        "amount" => $amount, 
	        "email" => $userEmail, 
	        "paymentMethod" => $this->getPaymentMethod(), 
	        "urlConfirmation" => $urlConfirmation, 
	        "urlReturn" => $urlReturn,
	        "optional" => ''
        );

		try{

			$flowApi = $this->getFlowApi();
			$this->log('Calling flow service: '.$serviceName.' with params: '.json_encode($params));
			$response = $flowApi->send($serviceName, $params, "POST");
			$this->log('Flow response: '.json_encode($response));
        	$redirect = $response["url"]."?token=".$response["token"];
        	header("location:$redirect");
        
    	}catch(Exception $e){
			$this->log($e->getCode()."-".$e->getMessage());
			$this->redirectToError();
    	}
	}

	/**
	 * Called by Flow asynchronously to confirm the payment
	 *
	 * @return void
	 */
	public function confirm(){

		try{
			
			$this->log('Entering the confirm callback...');

			if(!isset($_POST["token"])){
				$this->log("No se recibio el token");
				throw new Exception("No se recibió token", 1);
			}

			$token = filter_input(INPUT_POST, 'token');
			$params = array(
				"token" => $token
			);

			$serviceName = "payment/getStatus";
			$flowApi = $this->getFlowApi();
			$this->log('Calling flow service: '.$serviceName.' with params: '.json_encode($params));
			$response = $flowApi->send($serviceName, $params, "GET");
			$this->log('Flow response: '.json_encode($response));
        	$status = $response['status'];
        	$commerceOrder = $response['commerceOrder'];

        	$this->load->model('checkout/order');
			
			//Simulating production environment
			/*if($this->isPaidInFlow($status) && ($response['paymentData']['media'] == 'Multicaja' || $response['paymentData']['media'] == 'Servipag' )){
				$status = 1;
			}*/

			if($this->isPendingInFlow($status)){
				$this->setOrderAsPending($commerceOrder);
			}
			else {

				if($this->isPaidInFlow($status)){
					$this->approveOrder($commerceOrder);
				}

        	    if($this->isRejectedInFlow($status)){
					$this->rejectOrder($commerceOrder);
        	    }
        	    if($this->isCanceledInFlow($status)){
					$this->cancelOrder($commerceOrder);
        	    }
        	    
			}
		} 
		catch (Exception $e) { 
			$this->log("Error: " . $e->getCode() . " - " . $e->getMessage());
			throw $e;
		}
	}

	/**
	 * Called when Flow redirects the user from the payment gateway back to the store.
	 * @return mixed
	 */
	public function gatewayRedirect(){

		$this->log('Entering the gateway redirect...');
		try{
		
			if(!isset($_POST["token"])){
				$this->log("No se recibio el token");
				throw new Exception("No se recibió token", 1);
			}

			$token = filter_input(INPUT_POST, 'token');
			
			$params = array(
				"token" => $token
			);

			$serviceName = "payment/getStatus";
			$flowApi = $this->getFlowApi();
			$this->log('Calling Flow service: '.$serviceName. ' with params: '.json_encode($params));
			$response = $flowApi->send($serviceName, $params, "GET");
			$this->log('Flow response: '.json_encode($response));
        	$status = $response['status'];
        	$commerceOrder = $response['commerceOrder'];

        	$this->load->model('checkout/order');
			$order_info = $this->model_checkout_order->getOrder($commerceOrder);
			$isPaidInStore = $order_info['order_status_id'] == $this->config->get('flow_webpay_approved_status_id');

        	//We make a little simulation here in order to replicate the actual statuses that come in production, in this case,
			//whenever a coupon is generated in multicaja or servipag, the array key pending_info will be populated and paymentData won't,
			//and the status will be = 1, but unfortunately, in testing, everything comes as paid, that's why we're hacking this
			/*if($this->isPaidInFlow($status) && ($response['paymentData']['media'] == 'Multicaja' || $response['paymentData']['media'] == 'Servipag' )){
				
				$status = 1;
				$response['pending_info']['media'] = $this->medio_pago;
				unset($response['paymentData']);
			}*/

        	if($this->isPendingInFlow($status)){

				$this->setOrderAsPending($commerceOrder);

				//If the user generated a coupon
				if(($response['pending_info']['media']) != '' && $response['paymentData']['media'] == '' ){

					$this->clearCart();

					//Redirecting the user to the custom return url they configured.
					if(!empty($this->config->get('flow_webpay_urlreturn'))){
						$customReturnUrl = $this->config->get('flow_webpay_urlreturn');
						header("Location: $customReturnUrl");
						die();
					}

					//If the user didn't have a return url configured, we redirect them to a custom page
					$this->redirectToCouponGenerated();
				}

				//If the user cancelled the payment
				if($response['paymentData']['media'] == '' && $response['pending_info']['media'] == ''){
					//We redirect him back to the checkout!
					$this->redirectToCheckout();
				}
				
				//TODO: redirect to error
				//If we reach this point, there's nothing else to do but to show an error.
			}
			else if ($this->isPaidInFlow($status)){

				if(!$isPaidInStore){
					$this->approveOrder($commerceOrder);
				}

				$this->redirectToSuccess();
			}
			else {
				$this->rejectOrder($commerceOrder);
				$this->redirectToFailure();
			}
		} 
		catch (Exception $e) { 
			$this->log("Error: " . $e->getCode() . " - " . $e->getMessage());
			$this->redirectToError();
		}
	}

	private function approveOrder($orderId){
		$this->setOrderStatus($orderId, $this->config->get('flow_webpay_approved_status_id'), "Completado");
	}

	private function rejectOrder($orderId){
		$this->setOrderStatus($orderId, $this->config->get('flow_webpay_failed_status_id'), "Rechazado");
	}

	private function cancelOrder($orderId){
		$this->setOrderStatus($orderId, 16, "Cancelado");
	}

	private function setOrderAsPending($orderId){
		$this->setOrderStatus($orderId, 1, "Pendiente");
	}

	private function setOrderStatus($orderId, $status, $text = ""){
		$this->model_checkout_order->addOrderHistory($orderId, $status, $text, false, true);
	}

	private function isPaidInFlow($status){
		return $status == 2;
	}

	private function isPendingInFlow($status){
		return $status == 1;
	}

	private function isRejectedInFlow($status){
		return $status == 3;
	}

	private function isCanceledInFlow($status){
		return $status == 4;
	}

	private function redirectToSuccess(){
		$this->response->redirect($this->url->link('checkout/success', '', true));
	}

	private function redirectToFailure(){
		$this->response->redirect($this->url->link('checkout/failure', '', true));
	}

	private function redirectToError(){
		$this->response->redirect($this->url->link('extension/payment/flow_webpay/customError', '', true));
	}

	private function redirectToCheckout(){
		$this->response->redirect($this->url->link('checkout/checkout', '', true));
	}

	private function redirectToCouponGenerated(){
		$this->response->redirect($this->url->link('extension/payment/coupon', '', true));
	}

	private function getFlowApi(){

		$apiKey = $this->config->get('flow_webpay_apikey');
		$secretKey = $this->config->get('flow_webpay_secret');
		$url = $this->config->get('flow_webpay_apiurl');
		$url = ($url == "PROD") ? "https://www.flow.cl/api" : "https://sandbox.flow.cl/api";

		$flowApi = new FlowApiWebpay($apiKey, $secretKey, $url);
		return $flowApi;
	}

	private function clearCart(){

		if (isset($this->session->data['order_id'])) {
			$this->cart->clear();

			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['guest']);
			unset($this->session->data['comment']);
			unset($this->session->data['order_id']);
			unset($this->session->data['coupon']);
			unset($this->session->data['reward']);
			unset($this->session->data['voucher']);
			unset($this->session->data['vouchers']);
			unset($this->session->data['totals']);
		}
	}

	public function log($message){
		$log = new Log('flow_'.$this->medio_pago.".log");
		$log->write($message);
	}
}


class FlowApiWebpay {

	protected $apiKey;
	protected $secretKey;
	protected $endpoint;

	public function __construct($apiKey, $secretKey, $endpoint){
		$this->apiKey = $apiKey;
		$this->secretKey = $secretKey;
		$this->endpoint = $endpoint;
	}
	/**
	 * Funcion que invoca un servicio del Api de Flow
	 * @param string $service Nombre del servicio a ser invocado
	 * @param array $params datos a ser enviados
	 * @param string $method metodo http a utilizar
	 * @return string en formato JSON
	 */
	public function send( $service, $params, $method) {

		$method = strtoupper($method);
		$endpoint = $this->endpoint . "/" . $service;
		$params = array("apiKey" => $this->apiKey) + $params;
		$toSign = $this->getPack($params, $method);

		if(!function_exists("hash_hmac")) {
			throw new Exception("function hash_hmac not exist", 1);
		}
		$sign = hash_hmac('sha256', $toSign , $this->secretKey);

		if($method == "GET") {
			$response = $this->httpGet($endpoint, $toSign, $sign);
		} else {
			$response = $this->httpPost($endpoint, $toSign, $sign);
		}

		if(empty($response["output"]) && $response["info"]["http_code"] != 200) {
			throw new Exception("Unexpected error occurred. HTTP_CODE: " .$response["info"]["http_code"] , $response["info"]["http_code"]);
		}

		$body = json_decode($response["output"], true);
		if($response["info"]["http_code"] != 200) {
			throw new Exception($body["message"], $body["code"]);
		}

		return $body;
	}
	
	/**
	 * Funcion que empaqueta los datos para ser firmados
	 * @param array $params datos a ser empaquetados
	 * @param string $method metodo http a utilizar
	 */
	private function getPack($params, $method) {
		$keys = array_keys($params);
		sort($keys);
		$toSign = "";
		foreach ($keys as $key) {
			if($method == "GET") {
				$toSign .= "&" . rawurlencode($key) . "=" . rawurlencode($params[$key]);
			} else {
				$toSign .= "&" . $key . "=" . $params[$key];
			}
		}
		return substr($toSign, 1);
	}
	
	/**
	 * Funcion que hace el llamado via http GET
	 * @param string $url url a invocar
	 * @param array $data datos a enviar
	 * @param string $sign firma de los datos
	 * @return string en formato JSON 
	 */
	private function httpGet($url, $data, $sign) {
		$url = $url . "?" . $data . "&s=" . $sign;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		$output = curl_exec($ch);
		if($output === false) {
			$error = curl_error($ch);
			throw new Exception($error, 1);
		}
		$info = curl_getinfo($ch);
		curl_close($ch);
		return array("output" =>$output, "info" => $info);
	}
	
	/**
	 * Funcion que hace el llamado via http POST
	 * @param string $url url a invocar
	 * @param array $data datos a enviar
	 * @param string $sign firma de los datos
	 * @return string en formato JSON 
	 */
	private function httpPost($url, $data, $sign ) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data . "&s=" . $sign);
		$output = curl_exec($ch);
		if($output === false) {
			$error = curl_error($ch);
			throw new Exception($error, 1);
		}
		$info = curl_getinfo($ch);
		curl_close($ch);
		return array("output" =>$output, "info" => $info);
	}
}
