<?php

require_once __DIR__."/flowop/lib/FlowApi.class.php";
require_once __DIR__."/flowop/lib/Config.class.php";
use FlowApi\Onepay\FlowApi;
use FlowApi\Onepay\Config;

/**
 * Sets up necessary data for the WHMCS.
 */
function flowop_MetaData(){
    return array(
        'DisplayName'               =>  'Flow Onepay',
        'ApiVersion'                =>  '1.0',
        'DisableLocalCredCardInput' =>  true,
        'TokenisedStorage'          =>  false,
    );
}

/**
 * Flow configuration data that is displayed to the user when configuring the gateway payment systems they want to use.
 */
function flowop_config(){
    $config = array(

        'FriendlyName'  =>  array(
            'Type'  =>  'System',
            'Value' =>  'Flow Onepay'
        ),
        'mode'  =>  array(
            'FriendlyName'  =>  'Ambiente',
            'Type'          =>  'dropdown',
            'Options'       =>  Config::MODES,
            'Description'   =>  'Determina el endpoint de flow con el cual realizar&aacute; la transacci&oacute;n'
        ),
        'apiKey' =>  array(
            'FriendlyName'  =>  'Api Key',
            'Type'          =>  'text',
            'Size'          =>  90,
            'Default'       =>  '',
            'Description'   =>  'Introduzca la API KEY de Flow'
        ),

        'secretKey' =>  array(
            'FriendlyName'  =>  'Secret Key',
            'Type'          =>  'text',
            'Size'          =>  90,
            'Default'       =>  '',
            'Description'   =>  'Introduzca la SECRET KEY de Flow'
        ),
    );

    //If the payment method is anything different to webpay or onepay
    if(Config::PAYMENT_MODE > 1 && Config::PAYMENT_MODE !== 5)
    {
        $config['customReturnUrl'] = array(
            'FriendlyName'  =>  'URL de retorno',
            'Type'          =>  'text',
            'Size'          =>  90,
            'Default'       =>  '',
            'Description'   =>  'Ingresa la URL que ser&aacute; invocada luego de procesar el pago',
        );
    }
    return $config;
}

/**
 * Creates the order payment in flow and builds a neat button that will then be used to redirect the user
 * to flow to be then redirect to the final payment page.
 */
function flowop_link($params){ 


    global $CONFIG;
    logActivity('Entering flowop_link', 0);
    $urlConfirmation = $params['systemurl'].'modules/gateways/callback/flowop.php';
    $urlReturn = $CONFIG['SystemURL'].'/modules/gateways/flowop/flowop_return.php';
    $method = 'POST';
    $service = Config::SERVICES["payment"];
    $mode = $params['mode'];
    $paymentMode = Config::PAYMENT_MODE;
    $payNowText = $params['langpaynow'];
    $endpoint = Config::ENDPOINTS[$mode];

    $flowParams = array(
        'commerceOrder'     =>  $params['invoiceid'],
        'amount'            =>  $params['amount'],
        'email'             =>  $params['clientdetails']['email'],
        'subject'           =>  $params['description'],
        'urlConfirmation'   =>  $urlConfirmation,
        'urlReturn'         =>  $urlReturn,
        'paymentMethod'     =>  $paymentMode,
        'currency'          =>  $params['currency'],
    );
   
    $hiddenData = '';
    //We transform the data into hidden inputs in order to pass it to the script that will actually make the 
    //FLOW API calls
    foreach($flowParams as $key => $value){
        $hiddenData.= "<input type=\"hidden\" name=\"{$key}\" value=\"{$value}\">";
    }
    
    $urlToIntermediate = $params['systemurl']."modules/gateways/flowop/lib/Intermediate.php";
    return "<form method='POST' action=\"{$urlToIntermediate}\">{$hiddenData} <button type='submit' class='btn btn-primary'>{$payNowText}</button></form>";
        
}
