<?php

class FlowHelper{

    static function isPaidInFlow($status){
        return $status == 2;
    }
    
    static function isPendingInFlow($status){
        return $status == 1;
    }
    
    static function isCanceledInFlow($status){
        return $status == 3;
    }
    
    static function isRejectedInFlow($status){
        return $status == 4;
    }
    
    static function isTesting($flowOrderData, $flowConfig){
        return
            $flowConfig['mode'] == 'TEST' && 
            (strtolower($flowOrderData['paymentData']['media']) == 'multicaja' ||
            strtolower($flowOrderData['paymentData']['media']) == 'servipag');
    }
    
    static function setUpProductionEnvSimulation(&$flowOrderData){
        $flowOrderData['status'] = 1;
        $flowOrderData['pending_info']['media'] = $flowOrderData['paymentData']['media'];
        $flowOrderData['paymentData']['media'] = '';
    }

    static function userCanceledPayment($flowOrderData){
        return self::isPendingInFlow($flowOrderData['status'])
        && empty($flowOrderData['paymentData']['media'])
        && empty($flowOrderData['pending_info']['media']);
    }
}

